<style>
/* =====================================================
   HALAMAN CEK KELULUSAN – CSS ONLY
   (TIDAK MENGUBAH LOGIC BACKEND)
   ===================================================== */

h2 {
  font-size: 32px;
  margin-bottom: 20px;
  color: #1f2937;
  letter-spacing: 0.5px;
}

/* Alert sukses */
h2 + div {
  padding: 12px 16px !important;
  border-radius: 10px !important;
  font-weight: 600;
  color: #065f46;
  background: #d1fae5;
  border: 1px solid #34d399;
  box-shadow: 0 6px 20px rgba(16, 185, 129, 0.15);
  margin-bottom: 20px;
}

/* Card utama */
div[style*="max-width:700px"] {
  background: #ffffff;
  border: none !important;
  border-radius: 14px;
  padding: 24px !important;
  box-shadow: 0 18px 45px rgba(0,0,0,0.08);
}

/* Isi data */
div[style*="max-width:700px"] p {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 10px 0;
  margin: 0;
  border-bottom: 1px dashed #e5e7eb;
  font-size: 15px;
  color: #374151;
}

/* Label kiri */
div[style*="max-width:700px"] p b {
  min-width: 150px;
  color: #111827;
}

/* Status */
div[style*="max-width:700px"] p:nth-child(5) {
  font-weight: 700;
  color: #b91c1c;
}

/* HR */
div[style*="max-width:700px"] hr {
  margin: 18px 0;
  border: none;
  height: 1px;
  background: linear-gradient(to right, transparent, #cbd5e1, transparent);
}

/* Link */
div[style*="max-width:700px"] a {
  color: #2563eb;
  text-decoration: none;
  font-weight: 600;
}

div[style*="max-width:700px"] a:hover {
  text-decoration: underline;
}

/* Tombol kembali */
div[style*="max-width:700px"] > div a {
  display: inline-block;
  margin-top: 12px;
  padding: 10px 20px;
  background: #2563eb;
  color: #ffffff !important;
  border-radius: 10px;
  font-weight: 600;
  transition: all 0.3s ease;
}

div[style*="max-width:700px"] > div a:hover {
  background: #1e40af;
  transform: translateY(-2px);
  box-shadow: 0 10px 25px rgba(37, 99, 235, 0.35);
}

/* Responsive */
@media (max-width: 600px) {
  div[style*="max-width:700px"] p {
    flex-direction: column;
    align-items: flex-start;
    gap: 4px;
  }

  div[style*="max-width:700px"] p b {
    min-width: auto;
  }
}
</style>

<h2><?= esc($title ?? 'Cek Kelulusan') ?></h2>

<?php if (!empty($success)): ?>
  <div style="padding:10px;background:#d1fae5;border:1px solid #34d399;margin:10px 0;">
    <?= esc($success) ?>
  </div>
<?php endif; ?>

<div style="padding:14px;border:1px solid #ddd;border-radius:10px;max-width:700px;">
  <p><b>Tahun:</b> <?= esc($row['tahun'] ?? '-') ?></p>
  <p><b>NISN:</b> <?= esc($row['nisn'] ?? '-') ?></p>
  <p><b>Nama:</b> <?= esc($row['nama'] ?? '-') ?></p>
  <p><b>Kelas:</b> <?= esc($row['kelas'] ?? '-') ?></p>
  <p><b>Status:</b> <?= esc($row['status'] ?? '-') ?></p>

  <?php if (!empty($row['keterangan'])): ?>
    <p><b>Keterangan:</b> <?= esc($row['keterangan']) ?></p>
  <?php endif; ?>

  <hr>

  <p><b>File SKL:</b>
    <?php if (!empty($pdf_url)): ?>
      ✅ Ada |
      <a href="<?= esc($pdf_url) ?>" target="_blank">Lihat</a> |
      <a href="<?= esc($pdf_url) ?>" download>Download</a>
    <?php else: ?>
      ❌ Belum tersedia
    <?php endif; ?>
  </p>

  <div style="margin-top:14px;">
    <a href="<?= site_url('berita') ?>">⬅ Kembali</a>
  </div>
</div>
